#include "DRKAddOns.h"
#include "editor.h"
#include "addon.h"

// Our looper
APPILooper		*gLooper = NULL;
DRKTypeManager	*gTypeManager;

// The reciever function
void APPILooper::MessageReceived(BMessage *message)
{
	switch(message->what)
	{
		case kStartupPlugin:
			// We need to register all the things we do
			gTypeManager->RegisterEditor('APPI',APPICreateEditor);
			break;
		case kShutdownPlugin:
			// We don't need to do anything on stutdown.
			// The TypeManager will do all necessary cleanup
			Quit();
			break;
		default:
			// Pass it up
			BHandler::MessageReceived(message);
			break;
	}
}

// Creator
DRKEditor* APPICreateEditor(BResourceFile* resFile, long id)
{
	return (DRKEditor*) new APPIEditor(resFile,id);
}

// Entry function
void entry(BLooper** looper, DRKTypeManager *myMaster)
{
	gLooper = new APPILooper;
	gTypeManager = myMaster;
	gLooper->Run();
	*looper = gLooper;
}